<?php
/**
 * Bones Service Provider
 *
 * Register views and translations for the current component.
 *
 * PHP Version 7
 *
 * @category Mtc\Themes
 * @package  Mtc\Themes\Bones
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Themes\Bones\Providers;

use Illuminate\Support\ServiceProvider;

/**
 * Connect the Bones theme to Laravel
 *
 * @category Mtc\Themes
 * @package  Mtc\Themes\Bones
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class BonesServiceProvider extends ServiceProvider
{
    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        $this->defineResources();
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        if (! defined('THEME_PATH')) {
            define('THEME_PATH', realpath(__DIR__.'/../../'));
        }
    }

    /**
     * Define the resources for this package.
     *
     * @return void
     */
    protected function defineResources()
    {
        $this->loadViewsFrom(THEME_PATH . '/resources/views', 'theme');
        $this->loadTranslationsFrom(THEME_PATH . '/resources/lang', 'theme');
    }
}
