@extends('theme::layouts.public')

@section('content')

    <div class="pageWrap">


        <div class="titleWrap">
            <div class="innerText">
                <h1>Contact</h1>

            </div> <!-- .innerText -->
        </div> <!-- .titleWrap -->

        <div class="contactWrap contentPageWrap">

            <div class="contactFormWrap">

                @include('theme::partials.errors')

                @if (session('success'))
                    <p class="success">{{ __('ContactForm::form.success') }}</p>
                @else
                    <form action="{{ action('\Mtc\ContactForm\Http\Controllers\ContactController@handle') }}" method="post" class="contactForm" novalidate="novalidate">

                    <div class="row">
                        <label for="contactFormFullname">{{ __('ContactForm::form.name') }} <span class="formRequired">*</span></label>
                        <div class="inputWrap">
                            <input class="text" type="text" name="full_name" id="contactFormFullname" value="{{ old('full_name') }}">
                        </div>
                    </div>

                    <div class="row">
                        <label for="contactFormEmail">{{ __('ContactForm::form.email') }} <span class="formRequired">*</span></label>
                        <div class="inputWrap">
                            <input class="text" type="email" name="email" id="contactFormEmail" value="{{ old('email') }}">
                        </div>
                    </div>

                    <div class="row">
                        <label for="contactFormTelephone">{{ __('ContactForm::form.telephone') }}</label>
                        <div class="inputWrap">
                            <input class="text" type="tel" name="telephone" id="contactFormTelephone" value="{{ old('telephone') }}">
                        </div>
                    </div>

                    <div class="row">
                        <label for="contactFormMessage">{{ __('ContactForm::form.message') }} <span class="formRequired">*</span></label>
                        <div class="inputWrap">
                            <textarea class="text" name="message" id="contactFormMessage">{{ old('message') }}</textarea>
                        </div>
                    </div>

                    <input type="hidden" name="submit" value="true">
                    <input type="text" name="answer" value="" class="answer">

                    <button type="submit" name="trigger" class="button">{{ __('ContactForm::form.submit') }}</button>

                    {{ csrf_field() }}

                </form>
                @endif

            </div> <!-- .contactDetails -->

            <div class="contactDetails">



                <div class="detailsWrap">


                    <div class="address gridItem">






                    </div> <!-- .address .gridItem -->

                    <div class="gridItem">
                    </div> <!-- .gridItem -->

                </div> <!-- .addressWrap -->


            </div> <!-- .contactDetails -->

        </div> <!-- .contactWrap -->

    </div>

@endsection
