<?php

namespace Mtc\ContactForm;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;

/**
 * Class ContactFormServiceProvider
 *
 * @package Mtc\ContactForm
 */
class ContactFormServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        $this->defineResources();
        $this->defineRoutes();
    }

    /**
     * Define config, views and translations.
     *
     * @return void
     */
    public function defineResources()
    {
        if ($this->app->runningInConsole()) {
            $this->publishes(
                [
                    __DIR__.'/../config/config.php' => config_path('contact_form.php'),
                ], 'config'
            );
        }

        $this->loadViewsFrom(__DIR__.'/../resources/views', 'ContactForm');
        $this->loadTranslationsFrom(__DIR__ . '/../resources/lang', 'ContactForm');
    }

    /**
     * Define Routes
     *
     * @return void
     */
    public function defineRoutes()
    {
        /**
         * If the routes have not been cached, we will include them in a route group
         * so that all of the routes will be conveniently registered to the given
         * controller namespace. After that we will load the Core routes file.
         */
        if (! $this->app->routesAreCached()) {
            Route::group(
                ['namespace' => 'Mtc\ContactForm\Http\Controllers'],
                function ($router) {
                    $path = realpath(__DIR__ . '/../routes');
                    foreach (glob("{$path}/*.php") as $file) {
                        include $file;
                    }
                }
            );
        }
    }

    /**
     * Register the application services.
     */
    public function register()
    {
        $this->mergeConfigFrom(__DIR__.'/../config/config.php', 'ContactForm');
    }
}
