<?php
/**
 * Controller for Contact Form
 */

namespace Mtc\ContactForm\Http\Controllers;

use Mtc\ContactForm\Mail\ContactEmail;
use Mtc\Core\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Mail;

/**
 * Class ContactController
 *
 * @package Mtc\ContactForm\Http\Controllers
 */
class ContactController extends Controller
{
    /**
     * Display the contact form page.
     *
     * @param Request $request
     *
     * @return mixed
     */
    public function index(Request $request)
    {
        return view('ContactForm::form');
    }

    /**
     * Handle a contact form request
     *
     * @param Request $request
     *
     * @return mixed
     */
    public function handle(Request $request)
    {
        $this->validate(
            $request, [
            'full_name' => 'required|min:5',
            'email'     => 'required|email',
            'message'   => 'required|min:15',
            ]
        );

        // Has the honeypot been hit?
        $honeypot = $request->input('answer', '') != '';

        // Send email only if honeypot had not been hit
        if (false == $honeypot) {
            Mail::to(config('contact_form.to'))
                ->send(new ContactEmail($request->all()));
        }

        $request->session()->flash('success', true);
        return redirect(action('\\' . self::class . '@index'));
    }
}
