<?php

namespace Mtc\ContactForm\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

/**
 * Class ContactEmail
 *
 * @package Mtc\ContactForm\Mail
 */
class ContactEmail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var array Request input from contact page
     */
    public $input = [];

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(array $input)
    {
        $this->input = $input;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('ContactForm::emails.email')
            ->subject(__('ContactForm::email.subject'))
            ->with($this->input);
    }
}
