<custom-field-group item-in="{{ $item }}" inline-template v-cloak><div>
<div class="form-group">
    <label for="item_title">
        {{ trans('fields.title') }}
    </label>
        <input type="text"
            class="form-control"
            name="item[title]"
            id="item_title"
            placeholder="{{ trans('fields.title') }}"
            value="{{ Request::old('item.title', $item->title) }}"
            >
        @include('core::layouts.partials.admin.field_error', ['field' => 'item.title'])
</div>

<div class="form-group">
    <label for="item_table_name">
        {{ trans('fields.table_name') }}
    </label>
        <input type="text"
            class="form-control"
            name="item[table_name]"
            id="item_table_name"
            placeholder="{{ trans('fields.table_name') }}"
            v-model="item.table_name"
            >
        <div class="alert alert-warning" v-if="isDirty">
            Loading&hellip;
        </div>
        <div v-else="item.table_name.length > 0 && tableExists !== null">
            <div class="alert alert-success" role="alert" v-if="! tableExists">
                Good news, <strong>@{{ item.table_name }}</strong> is available.
            </div>
            <div class="alert alert-danger" role="alert" v-else>
                Sorry, <strong>@{{ item.table_name }}</strong> is not available.
            </div>
        </div>

        @include('core::layouts.partials.admin.field_error', ['field' => 'item.table_name'])
</div>

<div class="form-group">
    <label for="models">
        {{ trans('fields.models') }}
    </label>
    <select name="models"
        id="models"
        class="form-control"
        multiple>
    @foreach ($item->getRegisteredModels() as $model)
        <option
            @if (! $item->models->where('model', '=', $model)->isEmpty())
            selected
            @endif
            >{{ $model }}</option>
    @endforeach
    </select>
</div>

<table class="table table-striped">
    <thead>
        <tr>
            <th>{{ trans('fields.title') }}</th>
            <th>{{ trans('fields.column_name') }}</th>
            <th>{{ trans('fields.type') }}</th>
            <th>{{ trans('fields.list') }}</th>
            <th>{{ trans('fields.multiple') }}</th>
            <th></th>
        </tr>
    </thead>
    <tbody ref="sortable">
        <tr v-for="(field, index) in item.fields" track-by="$index">
            <td>

                <input type="hidden"
                    name="fields[ids][]"
                    v-model="field.id">

                <input type="text"
                    name="fields[title][]"
                    :placeholder="'Field ' + (index + 1)"
                    class="form-control"
                    v-model="field.title">
            </td>
            <td>
                <input type="text"
                    name="fields[column_name][]"
                    pattern="[A-Za-z0-9_]+"
                    class="form-control"
                    v-model="field.column_name">
            </td>
            <td>
                <select name="fields[type][]" class="form-control" v-model="field.type">
                    <option value="text">Text</option>
                    <option value="dropdown">Dropdown</option>
                </select>
            </td>
            <td>
                <select name="fields[list_id][]"
                    class="form-control"
                    v-model="field.list_id"
                    v-if="field.type == 'dropdown'">
                    <option value=""></option>
                    <option v-for="list in lists" :value="list.id">
                        @{{ list.title }}
                    </option>
                </select>
                <input v-else
                    type="hidden"
                    name="fields[list_id][]"
                    value="">
            </td>
            <td>
                <input type="checkbox"
                    v-model="field.multiple"
                    name="fields[multiple][]"
                    value="1"
                    title="{{ trans('fields.multiple') }}">

                <input type="hidden"
                    v-if="field.multiple != 1"
                    name="fields[multiple][]"
                    value="0">
            </td>
            <td width="1" class="text-right table-middle">
                <button class="btn btn-xs btn-danger"
                    title="Remove"
                    @click.prevent="deleteField(index)"
                    >&times;</button>
            </td>
        </tr>
    </tbody>
</table>

    <button class="btn btn-primary"
        @click.prevent="addField()">
        Add New Field
    </button>

</div></custom-field-group>
