<?php
/**
 * Controller for Users
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Http\Controllers\Admin
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests;
use App\User;
use Illuminate\Http\Request;
use Mtc\Core\Admin\Builder;
use Mtc\Core\Admin\ItemBuilder;
use Mtc\Core\Http\Requests\Admin\StoreUser;

/**
 * Controller for Users in Admin
 *
 * @category Mtc\Core\Http\Controllers\Admin
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class UserController extends Controller
{
    /**
     * Ensure this is only accessible to those with the permission to do so.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('permission:manage-users');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return (new Builder('core.admin.users', User::query()))
            ->view();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param User $user Empty user model
     *
     * @return \Illuminate\View\View
     */
    public function create(User $user)
    {
        return (new ItemBuilder('core.admin.users', $user))
            ->view();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreUser $request Validated Request
     * @param User      $user    Empty user model
     *
     * @return \Illuminate\Http\Response
     */
    public function store(StoreUser $request, User $user)
    {
        $user->fill($request->all())
            ->save();

        $user->roles()->sync($request->input('roles', []));

        return redirect(route('core.admin.users.index'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param User $user User Model
     *
     * @return \Illuminate\View\View
     */
    public function edit(User $user)
    {
        return (new ItemBuilder('core.admin.users', $user))
            ->view('core::admin.user.form');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param StoreUser $request Validated Request
     * @param User      $user    User to update
     *
     * @return \Illuminate\View\View
     */
    public function update(StoreUser $request, User $user)
    {
        return $this->store($request, $user);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @todo
     * @param int $id User ID
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
