<?php
/**
 * Delete Custom Data Listener
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Listeners
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\Listeners;

use Illuminate\Database\Eloquent\Model;
use Mtc\Core\Node;
use Mtc\Core\CustomFields\CustomGroup;

/**
 * Listen to a node deleting or changing group, so we can wipe associated data.
 *
 * @category Mtc\Core\Listeners
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class DeleteCustomData
{

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param Node $node Node which has triggered event
     *
     * @return void
     */
    public function handle(Node $node)
    {
        // If the group has changed, then delete existing records.
        if (!empty($node->getOriginal('group_id'))
            && $node->group_id != $node->getOriginal('group_id')
            && $node->id > 0
        ) {
            $group = CustomGroup::find($node->getOriginal('group_id'));
            \DB::table($group->table_name)
                ->where('node_id', '=', $node->id)
                ->delete();

            // Remove all associated taxonomies
            $node->taxonomies->detach();
        }
    }
}
