<?php
/**
 * Save Custom Data Listener
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Listeners
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\Listeners;

use Illuminate\Database\Eloquent\Model;
use Mtc\Core\Node;

/**
 * Listen to a node saved event so we can save related custom data included
 * in the same request.
 *
 * @category Mtc\Core\Listeners
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class SaveCustomData
{

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param Node $node Node which triggered event
     *
     * @return bool
     */
    public function handle(Node $node)
    {
        // Add any new data.
        $data = \Request::input('custom', []);
        if (empty($data) || is_null($node->group)) {
            return false;
        }

        return $node->saveGroupData($data);
    }
}
