<?php
/**
 * Trait to allow for the connection between a Model and corresponding Node.
 *
 * PHP Version 7
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core;

/**
 * Trait to allow for the connection between a Model and corresponding Node.
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
trait Nodeable
{
    /**
     * Define the relationship to the node.
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphOne
     */
    public function node()
    {
        return $this->morphOne(Node::class, 'nodeable');
    }
}
