<?php
/**
 * Core Event Service Provider
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Providers
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Event;
use Mtc\Core\Node;

/**
 * Within this class are all the events which the Core is listening and
 * reacting to.
 *
 * @category Mtc\Core\Providers
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class EventServiceProvider extends ServiceProvider
{
    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        Event::listen(
            'Illuminate\Auth\Events\Attempting',
            'Mtc\Core\Listeners\ValidateMtcLogin'
        );
        Event::listen('eloquent.deleted:*', 'Mtc\Core\Listeners\DeleteNode');
        Event::listen(
            'eloquent.saving: ' . Node::class,
            'Mtc\Core\Listeners\DeleteCustomData'
        );
        Event::listen(
            'eloquent.saved: ' . Node::class,
            'Mtc\Core\Listeners\SaveCustomData'
        );
    }
}
