@extends('core::layouts.admin')

@section('title', ($item->exists ? 'Edit ' : 'Add ') . ucfirst(str_singular($name)))

@section('content')

    <form method="POST" action="{{ $form_action }}">

        <div class="well well-sm">
            <button type="submit"
                    class="btn btn-success"
                    >Save</button>
        </div>

        @include('core::admin.builder.partials.tabs')

        @if (!is_null($node))
            @include('core::admin.builder.partials.node')
        @endif


        @if (!empty($view))
            <div class="well">
                @include($view)
            </div>
        @endif

        @if (!is_null($node))
            <custom-node node-in="{{ $node }}" class-name="{{ get_class($item) }}" inline-template><div>
                <div class="well" v-if="isAvailable">
                    <div class="form-group">
                        <label for="node_group_id">Type</label>
                        <select name="node[group_id]" id="node_group_id" v-model="node.group_id" class="form-control">
                            <option v-for="group in availableGroups" :value="group.id">
                                @{{ group.title }}
                            </option>
                        </select>
                    </div>

                    <div class="alert alert-info" v-if="isLoading">
                        <i class="glyphicon glyphicon-refresh spinning"></i>
                        Loading&hellip;
                    </div>

                    <div v-if="current_group.fields">
                        <div class="form-group" v-for="field in current_group.fields">
                            <label :for="'node_custom_' + field.column_name">
                                @{{ field.title }}
                            </label>

                            <select
                                v-model="current_group.data[field.column_name]"
                                class="form-control"
                                v-if="field.type == 'dropdown'"
                                :multiple="field.multiple == 1"
                                :name="'custom[' + field.column_name + ']' + (field.multiple == 1 ? '[]' : '')"
                                >
                                    <option value=""></option>
                                    <option v-for="list_item in field.list.items" :value="list_item.id">
                                        @{{ list_item.title }}
                                    </option>
                            </select>
                            <input type="text"
                                :name="'custom[' + field.column_name + ']'"
                                v-model="current_group.data[field.column_name]"
                                class="form-control"
                                v-else>
                        </div>
                    </div>
                </div>
            </div></custom-node>
        @endif

        {{-- Allow custom HTML form other components --}}
        @foreach (event(new \Mtc\Core\Events\Admin\ItemLoading($item)) as $response)
            {!! $response !!}
        @endforeach

        <div class="well well-sm">
            <button type="submit"
                    class="btn btn-success"
                    >Save</button>
            <div class="pull-right">
                <a class="btn btn-default" href="#top">Back to Top</a>
            </div>
        </div>

        {{ method_field($form_method) }}
        {{ csrf_field() }}
    </form>

@endsection
