<?php
/**
 * Allow global search by looking through Node results.
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Http\Controllers\Admin
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\Http\Controllers\Admin;

use Mtc\Core\Http\Controllers\Controller;
use Mtc\Core\Role;
use Illuminate\Http\Request;
use Mtc\Core\Node;

/**
 * Allow global search by looking through Node results.
 *
 * Used in the admin header to show a list of 10 closest results.
 *
 * @category Mtc\Core\Http\Controllers\Admin
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class SearchController extends Controller
{
    /**
     * Perform a search request.
     *
     * @param Request $request Normal request
     *
     * @return \Illuminate\Http\Response JSON response
     */
    public function search(Request $request)
    {
        $search = $request->input('search', '');

        return Node::search($request->input('search', ''))
            ->limit(10)
            ->get()
            ->map(
                function ($item) {
                    $item->nodeable;
                    return $item;
                }
            );
    }
}
