<div class="form-horizontal">

    <div class="form-group">
        <label for="name" class="col-sm-1 control-label">
            {{ trans('fields.name') }}
        </label>
        <div class="col-sm-11">
            <input type="text"
                class="form-control"
                name="name"
                id="name"
                placeholder="{{ trans('fields.name') }}"
                value="{{ Request::old('name', $item->name) }}"
                />
            @include('core::layouts.partials.admin.field_error', ['field' => 'name'])
        </div>
    </div>

    <div class="form-group">
        <label for="display_name" class="col-sm-1 control-label">
            {{ trans('fields.display_name') }}
        </label>
        <div class="col-sm-11">
            <input type="text"
                class="form-control"
                name="display_name"
                id="display_name"
                placeholder="{{ trans('fields.display_name') }}"
                value="{{ Request::old('display_name', $item->display_name) }}"
                />
            @include('core::layouts.partials.admin.field_error', ['field' => 'display_name'])
        </div>
    </div>

    <div class="form-group">
        <label for="description" class="col-sm-1 control-label">
            {{ trans('fields.description') }}
        </label>
        <div class="col-sm-11">
            <input type="text"
                class="form-control"
                name="description"
                id="description"
                placeholder="{{ trans('fields.description') }}"
                value="{{ Request::old('description', $item->description) }}"
                />
            @include('core::layouts.partials.admin.field_error', ['field' => 'description'])
        </div>
    </div>

</div>

@if (! $permissions->isEmpty())
    <h3>Permissions</h3>

    @foreach ($permissions as $permission)
        <div class="form-group">
            <div class="checkbox">
                <label>
                    <input type="checkbox"
                        name="permissions[]"
                        aria-describedby="permissions_{{ $permission->id }}"
                        {{ $item->perms->where('id', '=', $permission->id)->isEmpty() ? '' : 'checked' }}
                        value="{{ $permission->id }}">
                    {{ $permission->display_name }}
                </label>
                <span id="permissions_{{ $permission->id }}" class="help-block">
                    {{ $permission->description }}
                </span>
            </div>
        </div>
    @endforeach
@endif
