<?php
/**
 * Media Eloquent Model
 *
 * PHP Version 7
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core;

use DB;
use Illuminate\Database\Eloquent\Model;
use Mtc\Core\CustomFields\CustomGroup;
use Nicolaslopezj\Searchable\SearchableTrait;

/**
 * Media Eloquent Model
 *
 * Central location to store information about uploaded media.
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class Media extends Model
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'title',
        'type',
        'src',
        'parent_id',
        'parent_type',
    ];

    /**
     * Get a list of all owning parent models.
     *
     * @return \Illuminate\Database\Relations\MorphTo
     */
    public function parent()
    {
        return $this->morphTo();
    }

    public function getUrlAttribute()
    {
        return asset('storage/', $this->src);
    }
}
