<?php
/**
 * Core Country Class
 *
 * PHP Version 7
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   Rihards Silins <rihards.silins@mtcmedia.co.uk>
 */

namespace Mtc\Core;

/**
 * Eloquent Model for Countries
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   Rihards Silins Rihards Silins <rihards.silins@mtcmedia.co.uk>
 * @author   Vladislavs Ignatjevs <vladislavs.ignatjevs@mtcmedia.co.uk>
 */
class Country extends \Illuminate\Database\Eloquent\Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'code',
        'status',
        'order',
    ];

    /**
     * A relation to the states for this country.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function states()
    {
        return $this->hasMany(CountryState::class);
    }
}
