<?php
/**
 * CustomField Eloquent Model
 *
 * PHP Version 7
 *
 * @category Mtc\Core\CustomFields
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\CustomFields;

use Illuminate\Database\Eloquent\Model;
use Mtc\Core\Taxonomy;

/**
 * CustomField Eloquent Model
 *
 * Used to store data about a custom field so we know it exists and what it's
 * made out of.
 *
 * @category Mtc\Core\CustomFields
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class CustomField extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        // CustomGroup parent
        'group_id',
        // It's column name within the group's table
        'column_name',
        // It's type (text, textarea, wysiwyg, dropdown, etc)
        'type',
        // A taxonomy that should be used as options for this.
        'list_id',
        // Check if multiple options are selectable
        'multiple'
    ];

    /**
     * The relations which should have their timestamps updated if this model
     * is updated/created.
     *
     * @var array
     */
    protected $touches = ['group'];

    /**
     * The field's parent group.
     *
     * @return IIlluminate\Database\Eloquent\Relations\BelongsTo
     */
    protected function group()
    {
        return $this->belongsTo(CustomGroup::class);
    }

    /**
     * The related taxonomy/list for this field, if any.
     *
     * @return IIlluminate\Database\Eloquent\Relations\BelongsTo
     */
    protected function taxonomy()
    {
        return $this->belongsTo(Taxonomy::class, 'list_id')->with('node');
    }
}
