<?php
/**
 * Delete Node Listener
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Listeners
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\Listeners;

use DB;
use Illuminate\Database\Eloquent\Model;

/**
 * During login determine if the user/pass is a match for details
 * within the MTC Projects System for company emails only. The
 * user will be automatically logged in even if no account.
 *
 * @category Mtc\Core\Listeners
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmeida.co.uk>
 */
class DeleteNode
{

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param Model $model Model that triggered the event
     *
     * @return bool
     */
    public function handle(Model $model)
    {
        if (!empty($model->node)) {
            // Delete any custom data for this node
            if (!empty($model->node->group)) {
                DB::table($model->node->group->table_name)
                    ->where('node_id', '=', $model->node->id)
                    ->delete();
            }
            // Delete the node
            $model->node->delete();
        }

        return true;
    }
}
