<?php

namespace Mtc\Core\Providers;

use Illuminate\Support\Facades\Validator;
use Illuminate\Support\ServiceProvider;
use Schema;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);

        // add validation rule named 'alpha_dash_slash'
        Validator::extend('alpha_dash_url', function ($attribute, $value, $parameters, $validator) {
            //allow all alpha-numeric characters with slashes and dashes
            return preg_match("#^/[a-zA-Z0-9_/-]+$#", $value);
        });

        Validator::replacer('alpha_dash_url', function ($message, $attribute, $rule, $parameters) {
            return "The $attribute field must contain alpha-numeric values with slashes and dashes. "
                . "It must start with /";
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
