<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomFieldGroupsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('custom_lists', function(Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
        });

        Schema::create('custom_list_items', function(Blueprint $table) {
            $table->increments('id');
            $table->integer('list_id')->unsigned();
            $table->string('title');
            $table->integer('order')->index();
            $table->timestamps();

            $table->foreign('list_id')
                ->references('id')
                ->on('custom_lists')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });

        Schema::create('custom_groups', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title');
            $table->string('table_name')->unique();
            $table->timestamps();
        });

        Schema::create('custom_fields', function(Blueprint $table) {
            $table->increments('id');
            $table->integer('group_id')->unsigned();
            $table->string('title');
            $table->string('column_name');
            $table->string('type');
            $table->integer('list_id')->unsigned()->nullable();
            $table->boolean('multiple')->default(false);
            $table->integer('order')->index();
            $table->timestamps();

            $table->foreign('group_id')
                ->references('id')
                ->on('custom_groups')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->foreign('list_id')
                ->references('id')
                ->on('custom_lists')
                ->onUpdate('cascade')
                ->onDelete('set null');
        });

        Schema::table('nodes', function (Blueprint $table) {
            $table->integer('group_id')
                ->unsigned()
                ->nullable()
                ->index()
                ->after('nodeable_type');

            $table->foreign('group_id')
                ->references('id')
                ->on('custom_groups')
                ->onUpdate('cascade')
                ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('nodes', function (Blueprint $table) {
            $table->dropForeign(['group_id']);
            $table->dropColumn('group_id');
        });

        Schema::dropIfExists('custom_fields');
        Schema::dropIfExists('custom_groups');
        Schema::dropIfExists('custom_list_items');
        Schema::dropIfExists('custom_lists');
    }
}
