<?php
/**
 * Class CreateSeoBrowseContentTable
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017-04-18
 */
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateSeoBrowseContentTable
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017-04-18
 */
class CreateSeoBrowseContentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('seo_browse_content', function(Blueprint $table) {
            $table->increments('id');
            $table->string('title');
            $table->string('description');
            $table->timestamps();
        });

        Schema::create('seo_browse_content_taxonomies', function(Blueprint $table) {
            $table->increments('id');
            $table->integer('browse_content_page_id')->unsigned();
            $table->integer('node_id')->unsigned();
            $table->timestamps();

            $table->unique(['browse_content_page_id', 'node_id'], 'content_node_unique');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('seo_browse_content');
        Schema::drop('seo_browse_content_taxonomies');
    }
}
