<?php
/**
 * Class SeoSeeder
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
use Illuminate\Database\Seeder;
use Mtc\Core\Models\Seo\Setting;

/**
 * Class SeoSeeder
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class SeoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Define setting array
        $seo_settings = [
            [
                'key' => 'GA_USERAGENT',
                'value' => '',
                'description' => 'Google Analytics User Agent.'
                    . ' Fill this in to enable general GA tracking as well as GA e-commerce tracking.'
            ],
            [
                'key' => 'GTM_CONTAINER_ID',
                'value' => '',
                'description' => 'Google Tag Manager (enter value to enable GTM)'
            ],
            [
                'key' => 'META_AUTHOR',
                'value' => 'mtc.',
                'description' => 'Meta Author value'
            ],
        ];

        // Make sure all settings are added
        foreach ($seo_settings as $setting) {
            if (!Setting::where('key', $setting['key'])->count()) {
                Setting::create($setting);
            }
        }
    }
}
