<div class="form-horizontal">

    <div class="form-group">
        <label for="type" class="col-sm-1 control-label">
            {{ trans('fields.type') }}
        </label>
        <div class="col-sm-11">
            @if ($item->id)
                <input type="text"
                       class="form-control"
                       disabled
                       id="type"
                       placeholder="{{ trans('fields.url') }}"
                       value="{{ Request::old('type', $item->nodeable_type) }}"
                />
            @else

                <select class="form-control"
                        name="type"
                        id="type">
                    <option>{{ trans('Choose Url Source') }}</option>
                    @foreach ($resource_list as $resource)
                        <option value="{{ $resource }}" {{ Request::old('type') == $resource ? 'selected' : '' }}>
                            {{ class_basename($resource) }}
                        </option>
                    @endforeach
                </select>
            @endif
            @include('core::layouts.partials.admin.field_error', ['field' => 'type'])
        </div>
    </div>

    @if (!$item->id)
        <div class="form-group">
            <label for="taxonomies" class="col-sm-1 control-label">
                {{ trans('Selected Taxonomies for Url') }}
            </label>
            <div class="col-sm-11">
                <seo-browse-taxonomies name="taxonomies"
                                       options="{{ $taxonomies }}"
                                       selected="{{ $item->taxonomies }}"
                ></seo-browse-taxonomies>
                @include('core::layouts.partials.admin.field_error', ['field' => 'taxonomies'])
            </div>
        </div>
    @else
        <div class="form-group">
            <label for="taxonomies" class="col-sm-1 control-label">
                {{ trans('Selected Taxonomies for Url') }}
            </label>
            <div class="col-sm-11">

                <input type="text"
                       class="form-control"
                       disabled
                       id="type"
                       placeholder="{{ trans('fields.url') }}"
                       value="{{ $item->taxonomies->pluck('title')->implode(', ') }}"
                />
            </div>
        </div>
    @endif
    <div class="form-group">
        <label for="url" class="col-sm-1 control-label">
            {{ trans('fields.url') }}
        </label>
        <div class="col-sm-11">
            <input type="text"
                   class="form-control"
                   name="url"
                   id="url"
                   placeholder="{{ trans('fields.url') }}"
                   value="{{ Request::old('url', $item->url) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => 'url'])
        </div>
    </div>

</div>