/**
 * Public JS Loader
 *
 * This is used to load up any JS dependencies and components to the public interface
 *
 * @author Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

window.swal = require('sweetalert');
Vue.component('breadcrumbs', require('./components/public/breadcrumbs.vue'));

Vue.filter('currency', function (value) {
    // we need to multiply the price by currently selected product rate
    value = document.getElementById('selectedCurrency').getAttribute('data-rate') * value;
    /*
     * Load the currency #selectedCurrency element that holds the placeholder format for this currency
     * The placeholder will be set up to have 11.22 for cost so we need to change the costs accordingly
     * 11 must be replaced with full numbers of pounds/euros/dollars etc. (hence the bitwise division ~~(x/y))
     * 22 must be the pennies/cents with only 2 numbers, so clean it up too
     */
    return document.getElementById('selectedCurrency')
        .getAttribute('data-format')
        .replace('11', ~~(value / 100))
        .replace('22', (value % 100).toFixed(0));
});