<div class="form-horizontal">

    <div class="form-group">
        <label for="name" class="col-sm-1 control-label">
            {{ trans('fields.name') }}
        </label>
        <div class="col-sm-11">
            <input type="text"
                class="form-control"
                name="name"
                id="name"
                placeholder="{{ trans('fields.name') }}"
                value="{{ Request::old('name', $item->name) }}"
                />
            @include('core::layouts.partials.admin.field_error', ['field' => 'name'])
        </div>
    </div>

</div>

@if (! $permissions->isEmpty())
    <h3>Permissions</h3>

    @foreach ($permissions as $permission)
        <div class="form-group">
            <div class="checkbox">
                <label>
                    <input type="checkbox"
                        name="permissions[]"
                        aria-describedby="permissions_{{ $permission->id }}"
                        {{ $item->permissions->where('id', '=', $permission->id)->isEmpty() ? '' : 'checked' }}
                        value="{{ $permission->id }}">
                    {{ $permission->display_name }} <em class="text-info small">({{ $permission->name }})</em>
                </label>
                <span id="permissions_{{ $permission->id }}" class="help-block">
                    {{ $permission->description }}
                </span>
            </div>
        </div>
    @endforeach
@endif
