<?php

use Illuminate\Database\Seeder;
use League\Csv\Reader;
use Mtc\Core\Country;
use Mtc\Core\CountryState;

class CountrySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (Country::count() > 0) {
            return;
        }

        // This country list was derrived from:
        // https://github.com/datasets/country-codes/blob/master/data/country-codes.csv
        $countries = Reader::createFromPath(__DIR__ . '/data/countries.csv');
        foreach ($countries as $order => $country) {
            list ($name, $code) = $country;
            $country = Country::create(compact('name', 'code', 'order'));

            // These lists were retrieved by Paypal:
            // https://developer.paypal.com/docs/classic/api/country_codes/
            $states = __DIR__ . "/data/states/{$code}.csv";
            if (file_exists($states)) {
                $states = Reader::createFromPath($states);
                foreach ($states as $state) {
                    list($name, $code) = $state;
                    $state = new CountryState(compact('name', 'code'));
                    $state = $country->states()->save($state);
                }
            }
        }
    }
}
