@if (!empty($currencies))
    <div class="changeCurrency">
        <a rel="nofollow"
           class="selectedCurrency"
           id="selectedCurrency"
           data-rate="{{ $selected_currency->rate }}"
           data-format="{{ money_format('%.2n', 11.22) }}"
           data-base-format="{{ \Mtc\Core\Models\Currency::amountInBaseCurrency(11.22, $selected_currency) }}">
            {{ $selected_currency->code }} ({{ $selected_currency->getSymbol() }})
        </a>
        <ul class="currencySelector">
            @foreach ($currencies as $currency)
                <li>
                    <a href="{{ action('\\' . \Mtc\Core\Http\Controllers\CurrencyController::class . '@store') }}?rate={{ $currency->code }}">
                        {{ $currency->code }} ({{ $currency->getSymbol() }})
                    </a>
                </li>
            @endforeach
        </ul>
    </div> <!-- .changeCurrency -->
@else
    {{-- Fallback to main currency when multi-currency is disabled--}}
    <span class="hidden"
          id="selectedCurrency"
          data-rate="1"
          data-format={{ money_format('%.2n', 11.22) }}"></span>
@endif