<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CustomFieldEavUniqueKeyFix extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('custom_field_values', function(Blueprint $table) {
            try {
                $table->dropUnique('custom_field_values_node_id_group_id_field_id_unique');
            } catch (PDOException $e) {
                // If unique doesn't exist, then ignore.
            }
            $table->unique(['node_id', 'group_id', 'field_id', 'value']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
