<?php
/**
 * Class SeoSeeder
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
use Illuminate\Database\Seeder;
use Mtc\Core\Models\Seo\Setting;
use Mtc\Core\Models\Seo\Defaults;

/**
 * Class SeoSeeder
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class SeoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->seedDefaults();
        $this->seedSettings();
    }

    /**
     * Seed the default meta values
     */
    private function seedDefaults()
    {
        $defaults = [
            [
                'name' => 'Browse page',
                'path' => '/browse',
                'node' => '',
                'title' => '{TX:[Categories]:CURRENT} Products - Page {PAGE} | {SITE_NAME}',
                'description' => 'View our range of {TX:[Categories]:CURRENT} Products | {SITE_NAME}'
            ],
            [
                'name' => 'Product',
                'path' => '',
                'node' => 'Mtc\Shop\Product',
                'title' => '{TITLE} - {TX:[Categories]:CURRENT} | {SITE_NAME}',
                'description' => '{Title} | {SITE_NAME}'
            ],
        ];

        // Make sure all settings are added
        foreach ($defaults as $default) {
            Defaults::create($default);
        }
    }

    /**
     * Seed the default settings
     */
    private function seedSettings()
    {
        // Define setting array
        $seo_settings = [
            [
                'key' => 'GA_USERAGENT',
                'value' => '',
                'description' => 'Google Analytics User Agent.'
                    . ' Fill this in to enable general GA tracking as well as GA e-commerce tracking.'
            ],
            [
                'key' => 'GTM_CONTAINER_ID',
                'value' => '',
                'description' => 'Google Tag Manager (enter value to enable GTM)'
            ],
            [
                'key' => 'META_AUTHOR',
                'value' => 'mtc.',
                'description' => 'Meta Author value'
            ],
        ];

        // Make sure all settings are added
        foreach ($seo_settings as $setting) {
            if (!Setting::where('key', $setting['key'])->count()) {
                Setting::create($setting);
            }
        }
    }
}
