<?php

use Mtc\Core\Auth\Permission;
use Mtc\Core\Auth\Role;
use Illuminate\Database\Seeder;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $role = Role::firstOrNew(['id' => 1]);
        $role->id = 1;
        $role->name = 'mtc';
        $role->save();

        $permissions = [
            'admin',
            'manage-users',
            'delete-users',
            'manage-roles',
            'manage-custom-fields',
            'manage-custom-field-groups',
            'manage-custom-field-taxonomies',
            'manage-seo',
            'manage-seo-defaults',
            'manage-currencies',
            'manage-urls',
            'manage-seo-pages',
            'manage-media-meta'
        ];

        $permissions = collect($permissions)
            ->map(function ($name) use ($role) {
                $permission = Permission::firstOrNew(['name' => $name]);
                $permission->save();
                if (!$role->hasPermissionTo($name)) {
                    $role->givePermissionTo($name);
                }
                return $permission;
            });

        $role = Role::firstOrNew(['id' => 2]);
        $role->id = 2;
        $role->name = 'admin';
        $role->save();

        if (!$role->hasPermissionTo('admin')) {
            $role->givePermissionTo('admin');
        }
    }
}
