<div class="form-horizontal">

    <div class="form-group">
        <label for="name" class="col-sm-1 control-label">
            {{ trans('fields.name') }}
        </label>
        <div class="col-sm-11">
            <input type="text"
                   class="form-control"
                   name="name"
                   id="name"
                   placeholder="{{ trans('fields.name') }}"
                   value="{{ Request::old('name', $item->name) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => 'name'])
        </div>
    </div>

    <seo-default-type inline-template
                      default-in="{{ json_encode($item) }}">
        <div v-cloak>
            <div class="form-group">
                <label for="rule_type" class="col-sm-1 control-label">
                    {{ trans('Rule Type') }}
                </label>
                <div class="col-sm-11 checkbox">
                    <label for="rule_type_node">
                        <input type="radio"
                               name="rule_type"
                               @change="triggerRuleTypeChange()"
                               v-model="rule_type"
                               id="rule_type_node"
                               value="1"
                                {{ Request::old('node_type', $item->node_type) != '' ? 'checked' : '' }}/>
                        Node entity
                    </label><br/>
                    <label for="rule_type_path">
                        <input type="radio"
                               name="rule_type"
                               v-model="rule_type"
                               @change="triggerRuleTypeChange()"
                               id="rule_type_path"
                               value="2"
                                {{ Request::old('node_type', $item->node_type) == '' ? 'checked' : '' }}/>
                        URL Stub
                    </label>
                </div>
            </div>

            <div class="form-group" v-show="rule_type == 1">
                <label for="node_type" class="col-sm-1 control-label">
                    {{ trans('Node Type') }}
                </label>
                <div class="col-sm-11">
                    <select class="form-control"
                            name="node_type"
                            v-model="seo_default.node_type"
                            id="node_type">
                        <option value="">{{ trans('Choose Type') }}</option>
                        @foreach ($node_list as $node)
                            <option value="{{ $node }}">
                                {{ $node }}
                            </option>
                        @endforeach
                    </select>
                    @include('core::layouts.partials.admin.field_error', ['field' => 'node_type'])
                </div>
            </div>

            <div class="form-group" v-show="rule_type == 2">
                <label for="path" class="col-sm-1 control-label">
                    {{ trans('URL Stub') }}
                </label>
                <div class="col-sm-11">
                    <input type="text"
                           class="form-control"
                           v-model="seo_default.path"
                           name="path"
                           id="path"
                           placeholder="{{ trans('e.g. /browse') }}"
                           value="{{ Request::old('path', $item->path) }}"
                    />
                    @include('core::layouts.partials.admin.field_error', ['field' => 'path'])
                </div>
            </div>
        </div>
    </seo-default-type>


    <div class="form-group">
        <label class="col-sm-1 control-label">
            Supported Tags:
        </label>
        <div class="col-sm-11">
            @foreach ($supported_tags as $tag)
                <code>{{ $tag }}</code>
            @endforeach

        </div>
    </div>

    <div class="form-group">
        <label for="title" class="col-sm-1 control-label">
            {{ trans('fields.title') }}
        </label>
        <div class="col-sm-11">
            <input type="text"
                   class="form-control"
                   name="title"
                   id="title"
                   placeholder="{{ trans('fields.title') }}"
                   value="{{ Request::old('title', $item->title) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => 'title'])
        </div>
    </div>

    <div class="form-group">
        <label for="description" class="col-sm-1 control-label">
            {{ trans('fields.description') }}
        </label>
        <div class="col-sm-11">
            <input type="text"
                   class="form-control"
                   name="description"
                   id="description"
                   placeholder="{{ trans('fields.description') }}"
                   value="{{ Request::old('description', $item->description) }}"
            />
            @include('core::layouts.partials.admin.field_error', ['field' => 'description'])
        </div>
    </div>

</div>