<?php

namespace Mtc\Core\Providers;

use Illuminate\Support\Facades\Validator;
use Illuminate\Support\ServiceProvider;
use Schema;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);

        // add validation rule named 'alpha_dash_slash'
        Validator::extend('alpha_dash_url', function ($attribute, $value, $parameters, $validator) {
            //allow all alpha-numeric characters with slashes and dashes
            return preg_match("#^/[a-zA-Z0-9_/-]+$#", $value);
        });

        Validator::replacer('alpha_dash_url', function ($message, $attribute, $rule, $parameters) {
            return "The $attribute field must contain alpha-numeric values with slashes and dashes. "
                . "It must start with /";
        });

        // add validation rule named 'alpha_dash_slash'
        Validator::extend('alpha_dash_file', function ($attribute, $value, $parameters, $validator) {
            //allow all alpha-numeric characters with slashes and dashes
            return preg_match("#^[a-zA-Z0-9_-]+\.[a-zA-Z]{3,4}$#", $value);
        });

        Validator::replacer('alpha_dash_file', function ($message, $attribute, $rule, $parameters) {
            return "File must be a filename that consists of alpha-numeric values"
                . " with slashes and/or dashes.";
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
