<?php
/**
 * Class TriggerNpmInstall
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 17.04.2017
 */
namespace Mtc\Core\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

/**
 * Class TriggerNpmInstall
 *
 * This script loops through all mtc packages and finds npm dependencies that need to be installed
 * This way we do not have to update Laracore when a new dependency is added
 * Also ensures continuous upgradability
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017-04-17
 */
class TriggerNpmIncludeAndInstall extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'npm:include_and_install';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Triggers NPM install. Used after new packages have been added by dependencies';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command for generating a new certificate.
     *
     * @return mixed
     */
    public function handle()
    {
        // Get all package.json files under MTC vendor name
        $mtc_packages = glob(base_path('vendor/mtc/*/package.json'));

        // Only proceed if we have scripts to work with
        if (count($mtc_packages) == 0) {
            return true;
        }

        // Process package.json files to fetch required dependencies
        foreach ($mtc_packages as $package) {
            $package_file = json_decode(File::get($package));

            // Failed to decode package.json file
            if (!$package_file) {
                continue;
            }
            // Check if dev dependencies exist
            if (!empty($package_file->dependencies)) {
                foreach ($package_file->dependencies as $dependency => $version) {
                    // Execute install & save
                    exec("npm install $dependency@$version --save");

                }
            }

            // Check if dev dependencies exist
            if (!empty($package_file->devDependencies)) {
                foreach ($package_file->devDependencies as $dependency => $version) {
                    // Execute install & save
                    exec("npm install $dependency@$version --save-dev");

                }
            }

        }
    }

}