<?php
/**
 * CustomGroupModel Eloquent Model
 *
 * PHP Version 7
 *
 * @category Mtc\Core\CustomFields
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\CustomFields;

use Illuminate\Database\Eloquent\Model;

/**
 * Stores the name of any Eloquent models that have been selected for use
 * for the specified group.
 *
 * @category Mtc\Core\CustomFields
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class CustomGroupModel extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['model'];

    /**
     * Retrieve the parent group this belongs to.
     *
     * @return IIlluminate\Database\Eloquent\Relations\BelongsTo
     */
    public function group()
    {
        return $this->belongsTo(CustomGroup::class);
    }
}
