<?php
/**
 * Class Seo\Defaults
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Core\Models\Seo;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Mtc\Core\Node;

/**
 * Class Seo\Defaults
 *
 * Seo Defaults model
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class Defaults extends Model
{

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'seo_defaults';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'node',
        'path',
        'title',
        'description'

    ];

    /**
     * Get the seo defaults that are set for this node
     *
     * @param Node $node
     * @return Defaults|null
     */
    public static function getNodeDefaults(Node $node)
    {
        return self::where('node', $node->nodeable_type)
            ->first();
    }

    /**
     * Get the Seo Defaults that are set for this url
     *
     * Uses inverse matching (/browse/page-2 must match the entry for /browse)
     *
     * @param $url
     * @return mixed
     */
    public static function getDefaultsFromUrl($url)
    {
        $url = DB::getPdo()->quote($url);
        return self::where('path', '!=', '')
            ->whereRaw(DB::raw($url . ' LIKE CONCAT(`path`, "%")'))
            ->first();
    }
}
