<?php
/**
 * Class SeoComposer
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Core\Http\ViewComposers;

use Illuminate\View\View;
use Mtc\Core\Node;
use Mtc\Core\Models\Seo\Defaults;

/**
 * Class SeoComposer
 *
 * Add in the Seo information for views
 *
 * @package Mtc\Core
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class SeoComposer
{
    /**
     * Handle the view processing to add in required Seo fields
     *
     * @param View $view
     */
    public function compose(View $view)
    {
        $view->with(
            [
            'seo_data' => self::getSeoData(),
            ]
        );
    }

    /**
     * Generate Seo Data for current page
     *
     * @return object
     */
    public static function getSeoData()
    {
        // Get the URL of the page
        $url = request()->getPathInfo();

        // Check if node exists for this url
        $node = Node::where('url', $url)
            ->first();

        // Check Fallback to Seo Defaults
        $defaults = $node ? Defaults::getNodeDefaults($node) : Defaults::getDefaultsFromUrl($url);
        if ($defaults) {
            return $defaults;
        }

        // Final fallback to Site Config
        return (object)[
            'title' => config('app.name'),
            'description' => config('app.name')
        ];
    }
}
