@extends('core::layouts.admin')

@section('title', 'Manage ' . ucfirst($title))

@section('content')

    <div class="well well-sm">

        <a href="{{
            call_user_func_array('route', collect([
                "{$name}.create",
                $route_params,
            ])->flatten()->toArray())
        }}" class="btn btn-primary">
            Add New
        </a>

        @foreach ($views['buttons'] as $button)
            @include($button)
        @endforeach
    </div>

    @foreach ($views['head'] as $view)
        @include($view)
    @endforeach

    <div class="well">
        @if ($data->isEmpty())
            <p>Sorry, no results have been found.</p>
        @else
            {!! $data->render() !!}
                <table class="table table-striped">
                    <thead>
                        <tr>
                        @foreach ($columns as $column)
                            <th>{{ $column }}</th>
                        @endforeach
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($data as $item)
                            <tr>
                                @foreach ($columns as $key => $column)
                                    <td>{{ $item->$key }}</td>
                                @endforeach

                                <td class="text-right block">
                                    <div class="btn-group">
                                        <a href="{{ call_user_func_array('route', [
                                                "{$name}.edit",
                                                array_merge($route_params, [$item])
                                            ])}}"
                                            class="btn btn-primary">
                                            Edit
                                        </a>

                                        @if (empty($delete_permission) || \Auth::user()->can($delete_permission))
                                        <delete action="{{ call_user_func_array('route', [
                                            "{$name}.destroy",
                                            array_merge($route_params, [$item])
                                        ])}}"></delete>
                                        @endif
                                    </div>
                                </td>

                            </tr>
                        @endforeach
                    </tbody>
                </table>
            {!! $data->render() !!}
        @endif
    </div>

    @foreach ($views['foot'] as $view)
        @include($view)
    @endforeach

@endsection
