<div class="well">
    <div class="form-group">
        <label for="node_title">{{ trans('fields.title') }}</label>
        <input type="text"
            name="node[title]"
            id="node_title"
            class="form-control"
            placeholder="{{ trans('fields.title') }}"
            value="{{ Request::old('node.title', $node->title) }}"
            />
        @include('core::layouts.partials.admin.field_error', ['field' => 'node.title'])
    </div>

    @if (empty($hide_description))
        <div class="form-group">
            <label for="node_description">{{ trans('fields.description') }}</label>
            <textarea class="form-control tinymce"
                name="node[description]"
                id="node_description"
                >{{ Request::old('node.description', $node->description) }}</textarea>
            @include('core::layouts.partials.admin.field_error', ['field' => 'node.description'])
        </div>
    @endif

    <div class="form-group">
        <label for="node_status">{{ trans('fields.status') }}</label>
        <select name="node[status]"
            class="form-control"
            id="node_status"
            >
            {{-- @todo: Will replace with a config/event --}}
            @foreach(['published', 'draft'] as $status)
                <option value="{{ $status }}"
                    {{ $status == $node->status ? 'selected' : ''}}
                    >{{ trans('fields.status_options.' . $status) }}
                </option>
            @endforeach
        </select>
    </div>

    @if (empty($hide_visibility))
        <div class="form-group">
            <label for="node_visibility">{{ trans('fields.visibility') }}</label>
            <select name="node[visibility]"
                class="form-control"
                id="node_visibility"
                >
                {{-- @todo: Will replace with a config/event --}}
                @foreach(['public', 'private'] as $visibility)
                    <option value="{{ $visibility }}"
                        {{ $visibility == $node->visibility ? 'selected' : ''}}
                        >{{ trans('fields.visibility_options.' . $visibility) }}
                    </option>
                @endforeach
            </select>
        </div>
    @endif
</div>
