<?php
/**
 * Web Routes
 *
 * This file is where you may define all of the routes that are handled
 * by your application. Just tell Laravel the URIs it should respond
 * to using a Closure or controller method. Build something great!
 *
 * PHP Version 7
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

use Mtc\Core\Admin\Menu;
use Mtc\Core\Events\Admin\MenuLoading;

$router->group(
    [
        'prefix' => 'admin',
        'middleware' => ['web', 'auth', 'permission:admin'],
        'as' => 'core.admin.'
    ],
    function ($router) {

        // Homepage
        $router->get(
            '/', function () {
                return view('core::admin.home');
            }
        )->name('home');

        $router->post('search', Admin\SearchController::class . '@search')->name('search');

        $router->resource('users', Admin\UserController::class);
        $router->resource('roles', Admin\RoleController::class);

        $router->group(
            [
                'prefix' => 'custom-fields',
                'as' => 'custom-fields.',
                'middleware' => ['permission:manage-custom-fields'],
            ], function ($router) {
                $router->resource('groups', Admin\CustomFields\GroupController::class);
                $router->post('groups/tableExists', Admin\CustomFields\GroupController::class . '@postTableExists');
            }
        );

        $router->post('taxonomies/{taxonomy}', Admin\TaxonomyController::class . '@storeChild')
            ->name('taxonomy.storeChild');
        $router->resource('taxonomies', Admin\TaxonomyController::class);

        // SEO
        $router->group([
            'prefix' => 'seo',
            'as' => 'seo.',
            'middleware' => ['permission:manage-seo'],
        ], function ($router) {
            // SEO Defaults
            $router->resource('defaults', Admin\Seo\DefaultsController::class);
            $router->resource('settings', Admin\Seo\SettingsController::class);
        });
    }
);


Event::listen(
    MenuLoading::class, function () {
        Menu::addSection('Management', 'management');
        Menu::addMenu('management', 'Users', '', 'users', 'glyphicon glyphicon-user');
        Menu::addSubMenu('users', 'Manage Users', 'manage-users', route('core.admin.users.index'), 'manage_users');
        Menu::addSubMenu('users', 'Manage Roles', 'manage-roles', route('core.admin.roles.index'), 'manage_roles');

        Menu::addMenu('management', 'Custom Fields', 'manage-custom-fields', 'custom-fields');
        Menu::addSubMenu(
            'custom-fields',
            'Groups',
            'manage-custom-field-groups',
            route('core.admin.custom-fields.groups.index'),
            'custom-field-groups'
        );
        Menu::addSubMenu(
            'custom-fields',
            'Taxonomies',
            'manage-custom-field-taxonomies',
            route('core.admin.taxonomies.index'),
            'custom-field-taxonomies'
        );

        // SEO menu items
        Menu::addMenu(
            'management',
            'Seo',
            'manage-seo',
            'seo-admin'
        );
        Menu::addSubMenu(
            'seo-admin',
            'Seo Settings',
            'manage-seo',
            route('core.admin.seo.settings.index'),
            'manage-seo-settings'
        );
        Menu::addSubMenu(
            'seo-admin',
            'Seo Defaults',
            'manage-seo-defaults',
            route('core.admin.seo.defaults.index'),
            'manage-seo-defaults'
        );

    }
);
