<?php
/**
 * StoreRole Request
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Http\Requests\Admin
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Validate an incoming request for storing roles with custom rules.
 *
 * @category Mtc\Core\Http\Requests\Admin
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class StoreRole extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $role = \Route::input('role', null);

        return [
            'name' => 'required|max:255|unique:roles,name,' . (is_null($role) ? 0 : $role->id),
            'display_name' => 'required|max:255',
            'description' => 'required|max:255',
        ];
    }
}
