<?php
/**
 * Core View Composer Service Provider
 *
 * PHP Version 7
 *
 * @category Mtc\Core\Providers
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Core\Providers;

use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Mtc\Core\Http\ViewComposers\EntrustComposer;
use Mtc\Core\Http\ViewComposers\SeoComposer;

/**
 * Registers view composers for any views.
 *
 * @category Mtc\Core\Providers
 * @package  Mtc\Core\Admin
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class ComposerServiceProvider extends ServiceProvider
{
    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        View::composer('core::admin.user.form', EntrustComposer::class);
        View::composer('core::admin.role.form', EntrustComposer::class);
        // All requests go through Seo
        View::composer('*', SeoComposer::class);
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
