/**
 * Admin JS Loader
 *
 * This is used to load up any JS dependencies and components to the Admin
 * interface.
 *
 * @author Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

window.swal = require('sweetalert');

// Ensure Dropzone doesn't auto-start and includes the necessary CSRF token automatically.
window.Dropzone = require('dropzone');
Dropzone.autoDiscover = false;
Dropzone.options.imageUpload = {
    headers: {'X-CSRF-TOKEN': Laravel.csrfToken },
    acceptedFiles: 'image/*'
};

tinymce.init(
    {
        selector: '.tinymce'
    }
);


Vue.use(require('vue-sortable'));
Vue.component('delete', require('./components/admin/delete.vue'));
Vue.component('custom-field-list', require('./components/admin/custom-field-list.vue'));
Vue.component('custom-field-group', require('./components/admin/custom-field-group.vue'));
Vue.component('custom-node', require('./components/admin/custom-node.vue'));
Vue.component('search', require('./components/admin/search.vue'));
Vue.component('taxonomy', require('./components/admin/taxonomy.vue'));
Vue.component('seo-default-type', require('./components/admin/seo_default_type.vue'));
Vue.component('seo-browse-taxonomies', require('./components/admin/seo_browse_content.vue'));
Vue.component('knowledge-graph', require('./components/admin/knowledge_graph.vue'));
Vue.component('date-picker', require('./components/admin/datepicker.vue'));
