<?php
/**
 * Web Routes
 *
 * This file is where you may define all of the routes that are handled
 * by your application. Just tell Laravel the URIs it should respond
 * to using a Closure or controller method. Build something great!
 *
 * PHP Version 7
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

use Mtc\Core\Admin\Menu;
use Mtc\Core\Events\Admin\MenuLoading;
use Illuminate\Routing\Router;

/**
 * @var Router $router
 */
$router->group(
    [
        'prefix' => 'admin',
        'middleware' => ['web', 'auth', 'permission:admin'],
        'as' => 'core.admin.'
    ],
    function (Router $router) {

        // Homepage
        $router->get(
            '/', function () {
                return view('core::admin.home');
            }
        )->name('home');

        $router->post('search', Admin\SearchController::class . '@search')->name('search');

        $router->resource('users', Admin\UserController::class);
        $router->resource('roles', Admin\RoleController::class);

        $router->group(
            [
                'prefix' => 'custom-fields',
                'as' => 'custom-fields.',
                'middleware' => ['permission:manage-custom-fields'],
            ], function (Router $router) {
                $router->resource('groups', Admin\CustomFields\GroupController::class);
                $router->post('groups/tableExists', Admin\CustomFields\GroupController::class . '@postTableExists');
            }
        );

        $router->post('taxonomies/{taxonomy}', Admin\TaxonomyController::class . '@storeChild')
            ->name('taxonomy.storeChild');
        $router->resource('taxonomies', Admin\TaxonomyController::class);

        // SEO
        $router->group([
            'prefix' => 'seo',
            'as' => 'seo.',
            'middleware' => ['permission:manage-seo'],
        ], function (Router $router) {
            // SEO Defaults
            $router->resource('browse_content', Admin\Seo\BrowseContentController::class);
            $router->resource('defaults', Admin\Seo\DefaultsController::class);

            // Page meta value management (title, description, h1)
            $router->post('page_meta_tags/bulk_upload', Admin\Seo\PageController::class . '@bulkUpload')
                ->name('page_meta_tags.bulk_upload');
            $router->get('page_meta_tags/bulk_example', Admin\Seo\PageController::class . '@bulkExampleDownload')
                ->name('page_meta_tags.bulk_example');
            $router->resource('page_meta_tags', Admin\Seo\PageController::class);

            // Seo Settings
            $router->resource('settings', Admin\Seo\SettingsController::class);

            // Knowledge Graph
            $router->post('knowledge_graph/{knowledge_graph}', Admin\Seo\KnowledgeGraphController::class . '@storeChild')
                ->name('knowledge_graph.storeChild');
            $router->get('knowledge_graph/preview', Admin\Seo\KnowledgeGraphController::class . '@preview')
                ->name('knowledge_graph.preview');
            $router->resource('knowledge_graph', Admin\Seo\KnowledgeGraphController::class);
        });
    }
);


Event::listen(
    MenuLoading::class, function () {
        Menu::addSection('Management', 'management');
        Menu::addMenu('management', 'Users', '', 'users', 'glyphicon glyphicon-user');
        Menu::addSubMenu('users', 'Manage Users', 'manage-users', route('core.admin.users.index'), 'manage_users');
        Menu::addSubMenu('users', 'Manage Roles', 'manage-roles', route('core.admin.roles.index'), 'manage_roles');

        Menu::addMenu('management', 'Custom Fields', 'manage-custom-fields', 'custom-fields');
        Menu::addSubMenu(
            'custom-fields',
            'Groups',
            'manage-custom-field-groups',
            route('core.admin.custom-fields.groups.index'),
            'custom-field-groups'
        );
        Menu::addSubMenu(
            'custom-fields',
            'Taxonomies',
            'manage-custom-field-taxonomies',
            route('core.admin.taxonomies.index'),
            'custom-field-taxonomies'
        );

        // SEO menu items
        Menu::addMenu(
            'management',
            'Seo',
            'manage-seo',
            'seo-admin'
        );
        Menu::addSubMenu(
            'seo-admin',
            'Seo Settings',
            'manage-seo',
            route('core.admin.seo.settings.index'),
            'manage-seo-settings'
        );
        Menu::addSubMenu(
            'seo-admin',
            'Listing Page Content',
            'manage-seo',
            route('core.admin.seo.browse_content.index'),
            'manage-seo-browse-content'
        );
        Menu::addSubMenu(
            'seo-admin',
            'Seo Defaults',
            'manage-seo-defaults',
            route('core.admin.seo.defaults.index'),
            'manage-seo-defaults'
        );
        Menu::addSubMenu(
            'seo-admin',
            'Page Metadata',
            'manage-seo-pages',
            route('core.admin.seo.page_meta_tags.index'),
            'manage-seo-pages'
        );
        Menu::addSubMenu(
            'seo-admin',
            'Knowledge Graph',
            'manage-seo',
            route('core.admin.seo.knowledge_graph.index'),
            'manage-seo'
        );

    }
);
