<?php

use Mtc\Core\Auth\Permission;
use Mtc\Core\Auth\Role;
use Illuminate\Database\Seeder;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $role = Role::firstOrNew(['id' => 1]);
        $role->id = 1;
        $role->name = 'mtc';
        $role->display_name = 'mtc.';
        $role->description = 'Super Administrator';
        $role->save();

        $permissions = [
            'admin' => 'Access Admin Area',
            'manage-users' => 'Manage Users',
            'delete-users' => 'Delete Users',
            'manage-roles' => 'Manage Roles',
            'manage-custom-fields' => 'Manage Custom Fields',
            'manage-custom-field-groups' => 'Manage Custom Field Groups',
            'manage-custom-field-taxonomies' => 'Manage Custom Field Taxonomies',
            'manage-seo' => 'Manage Seo',
            'manage-seo-defaults' => 'Manage Seo Defaults',
        ];

        $permissions = collect($permissions)
            ->map(function ($display_name, $name) {
                $permission = Permission::firstOrNew(['name' => $name]);
                $permission->display_name = $display_name;
                $permission->save();
                return $permission;
            });

        $role->perms()->sync(Permission::pluck('id')->toArray());

        $role = Role::firstOrNew(['id' => 2]);
        $role->id = 2;
        $role->name = 'admin';
        $role->display_name = 'Administrator';
        $role->save();

        $role->perms()->sync(Permission::whereName('admin')->pluck('id')->toArray());
    }
}
