@extends('theme::layouts.public')
@section('content')
    <div class="container wrapper">
        <div id="content">
            <form action="{{ $page_details['route'] }}" method="POST" class="withBackground formInline">
                {{ csrf_field() }}
                {{ method_field($page_details['method']) }}
                <fieldset>
                    <div class="row {{ $errors->has('addresses.user.name') ? 'errorWrap showError' : '' }}">
                        <label for="name">{{ trans('core::fields.address.name') }}</label>
                        <div class="inputWrap">
                            <input name="addresses[user][name]" id="name"
                                   value="{{ old('addresses.user.name', $address->name) }}">
                            @include('core::public.addresses.error', ['field' => 'addresses.user.name'])
                        </div>
                    </div>
                    <div class="row {{ $errors->has('addresses.user.first_name') ? 'errorWrap showError' : '' }}">
                        <label for="first_name">{{ trans('core::fields.address.first_name') }}</label>
                        <div class="inputWrap">
                            <input name="addresses[user][first_name]" id="first_name"
                                   value="{{ old('addresses.user.first_name', $address->first_name) }}">
                            @include('core::public.addresses.error', ['field' => 'addresses.user.first_name'])
                        </div>
                    </div>
                    <div class="row {{ $errors->has('addresses.user.last_name') ? 'errorWrap showError' : '' }}">
                        <label for="last_name">{{ trans('core::fields.address.last_name') }}</label>
                        <div class="inputWrap">
                            <input name="addresses[user][last_name]" id="last_name"
                                   value="{{ old('addresses.user.last_name', $address->last_name) }}">
                            @include('core::public.addresses.error', ['field' => 'addresses.user.last_name'])
                        </div>
                    </div>
                    <div class="row {{ $errors->has('addresses.user.address1') ? 'errorWrap showError' : '' }}">
                        <label for="address1">{{ trans('core::fields.address.address1') }}</label>
                        <div class="inputWrap">
                            <input name="addresses[user][address1]" id="address1"
                                   value="{{ old('addresses.user.address1', $address->address1) }}">
                            @include('core::public.addresses.error', ['field' => 'addresses.user.address1'])
                        </div>
                    </div>
                    <div class="row {{ $errors->has('addresses.user.address2') ? 'errorWrap showError' : '' }}">
                        <label for="address2">{{ trans('core::fields.address.address2') }}</label>
                        <div class="inputWrap">
                            <input name="addresses[user][address2]" id="address2"
                                   value="{{ old('addresses.user.address2', $address->address2) }}">
                            @include('core::public.addresses.error', ['field' => 'addresses.user.address2'])
                        </div>
                    </div>
                    <div class="row {{ $errors->has('addresses.user.city') ? 'errorWrap showError' : '' }}">
                        <label for="city">{{ trans('core::fields.address.city') }}</label>
                        <div class="inputWrap">
                            <input name="addresses[user][city]" id="city"
                                   value="{{ old('addresses.user.city', $address->city) }}">
                            @include('core::public.addresses.error', ['field' => 'addresses.user.city'])
                        </div>
                    </div>
                    <div class="row {{ $errors->has('addresses.user.state') ? 'errorWrap showError' : '' }}">
                        <label for="state">{{ trans('core::fields.address.state') }}</label>
                        <div class="inputWrap">
                            <input name="addresses[user][state]" id="state"
                                   value="{{ old('addresses.user.state', $address->state) }}">
                            @include('core::public.addresses.error', ['field' => 'addresses.user.state'])
                        </div>
                    </div>
                    <div class="row {{ $errors->has('addresses.user.postcode') ? 'errorWrap showError' : '' }}">
                        <label for="postcode">{{ trans('core::fields.address.postcode') }}</label>
                        <div class="inputWrap">
                            <input name="addresses[user][postcode]" id="postcode"
                                   value="{{ old('addresses.user.postcode', $address->postcode) }}">
                            @include('core::public.addresses.error', ['field' => 'addresses.user.postcode'])
                        </div>
                    </div>
                    <div class="row {{ $errors->has('addresses.user.country') ? 'errorWrap showError' : '' }}">
                        <label for="country">{{ trans('core::fields.address.country') }}</label>
                        <div class="inputWrap">
                            <select name="addresses[user][country]" id="country">
                                @foreach ($countries as $country)
                                    <option value="{{ $country->code }}"
                                            {{ $address->country == $country->code ? 'selected' : '' }}>
                                        {{ $country->name }}</option>
                                    }
                                @endforeach
                            </select>
                            @include('core::public.addresses.error', ['field' => 'addresses.user.country'])
                        </div>
                    </div>
                </fieldset>
                <button type="submit" class="button">{{ trans('core::text.save') }}</button>
            </form>
        </div>
    </div>
@endsection
