@extends('theme::layouts.public')
@section('content')
    <div class="container wrapper">
        <div id="content">
            <div class="row">
                <div>
                    <div>
                        <a class="button buttonSmall"
                           href="{{ route('core.member.addresses.create') }}">{{ trans('core::text.create_new_address') }}</a>
                    </div>
                </div>
                <table class="alternating">
                    @foreach($addresses as $address)
                        <tr>
                            <td>{{ $address->name }}</td>
                            @if(Auth::user()->default_address == $address->id)
                                <td>
                                    <button id="address-default"
                                            class="buttonAlt buttonSmall">{{ trans('core::text.is_default') }}</button>
                                </td>
                            @else
                                <td>
                                    <form method="post"
                                          action="{{ route('core.member.addresses.default', $address->id) }}">
                                        {{ csrf_field() }}
                                        <input name="id" value="{{ $address->id }}" type="hidden">
                                        <button id="set-address-default"
                                                class="button buttonSmall">{{ trans('core::text.set_as_default') }}</button>
                                    </form>
                                </td>
                            @endif
                            <td>{{ $address->address1 }}</td>
                            <td>{{ $address->city }}</td>
                            <td>{{ $address->postcode }}</td>
                            <td>
                                <a href="{{ route('core.member.addresses.edit', $address->id) }}"
                                   class="button buttonSmall">{{ trans('core::text.edit') }}</a>
                            </td>
                            <td>
                                <delete action="{{ route('core.member.addresses.destroy', $address->id) }}"
                                        redirect="{{ route('core.member.addresses.index') }}"
                                        text="{{ trans('core::text.delete') }}"></delete>
                            </td>
                        </tr>
                    @endforeach
                </table>
            </div>
        </div>
    </div>
@endsection
