<?php
/**
 * Web Routes
 *
 * This file is where you may define all of the routes that are handled
 * by your application. Just tell Laravel the URIs it should respond
 * to using a Closure or controller method. Build something great!
 *
 * PHP Version 7
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

use Illuminate\Routing\Router;

/**
 * @var Router $router
 */
$router->group([
    'middleware' => ['web'],
], function (Router $router) {

    $router->resource('/', HomeController::class);
    $router->get('/destroy', HomeController::class . '@clearSession');

    // Currency Change Route, e.g. /currency?rate=EUR
    $router->get('currency', CurrencyController::class . '@store');

    // Set a pattern wildcard for all storage file requests
    // This regex matches all alpha-dash files with full path (forward slash allowed)
    $router->pattern('storage_file', "[a-zA-Z0-9\/\.\-\_]+");

    // The storage path must match what is defined in config.filesystems.disks.public.root
    $router->get('storage/{storage_file}', MediaController::class . '@show');
    $router->resource('media', MediaController::class);

});


$router->group(
    [
        'prefix' => config('core.member.prefix'),
        'middleware' => ['web', 'auth'],
        'as' => 'core.member.'
    ],
    function (Router $router) {
        if (config('core.member.pages.addresses')) {
            $router->resource('/addresses', AddressController::class, ['except' => ['show']]);
            $router->post('/addresses/default', AddressController::class . '@setDefault')->name('addresses.default');
        }
    }
);

$router->group(
    [
        'prefix' => config('core.admin_prefix'),
        'middleware' => ['web', 'auth', 'permission:admin'],
        'as' => 'core.admin.'
    ],
    function (Router $router) {
        // Homepage
        $router->resource('/', Admin\HomeController::class);

        $router->post('search', Admin\SearchController::class . '@search')->name('search');

        $router->resource('users', Admin\UserController::class);
        $router->resource('roles', Admin\RoleController::class);
        $router->resource('currencies', Admin\CurrencyController::class);

        $router->group(
            [
                'prefix' => 'custom-fields',
                'as' => 'custom-fields.',
                'middleware' => ['permission:manage-custom-fields'],
            ], function (Router $router) {
            $router->resource('groups', Admin\CustomFields\GroupController::class);
            $router->post('groups/tableExists', Admin\CustomFields\GroupController::class . '@postTableExists');
        }
        );

        $router->post('taxonomies/change_parent', Admin\TaxonomyController::class . '@changeParent');
        $router->post('taxonomies/list', Admin\TaxonomyController::class . '@displayList');
        $router->post('taxonomies/update_order', Admin\TaxonomyController::class . '@updateOrder');
        $router->post('taxonomies/{taxonomy}', Admin\TaxonomyController::class . '@storeChild')
            ->name('taxonomy.storeChild');
        $router->resource('taxonomies', Admin\TaxonomyController::class);

        // SEO
        $router->group([
            'prefix' => 'seo',
            'as' => 'seo.',
            'middleware' => ['permission:manage-seo'],
        ], function (Router $router) {
            // SEO Defaults
            $router->resource('browse_content', Admin\Seo\BrowseContentController::class);
            $router->resource('defaults', Admin\Seo\DefaultsController::class);

            // Custom Url management
            $router->resource('urls', Admin\Seo\CustomUrlController::class);

            // Page meta value management (title, description, h1)
            $router->post('page_meta_tags/bulk_upload', Admin\Seo\PageController::class . '@bulkUpload')
                ->name('page_meta_tags.bulk_upload');
            $router->get('page_meta_tags/bulk_example', Admin\Seo\PageController::class . '@bulkExampleDownload')
                ->name('page_meta_tags.bulk_example');
            $router->resource('page_meta_tags', Admin\Seo\PageController::class);

            // Seo Settings
            $router->resource('settings', Admin\Seo\SettingsController::class);

            // Knowledge Graph
            $router->post('knowledge_graph/{knowledge_graph}',
                Admin\Seo\KnowledgeGraphController::class . '@storeChild')
                ->name('knowledge_graph.storeChild');
            $router->get('knowledge_graph/preview', Admin\Seo\KnowledgeGraphController::class . '@preview')
                ->name('knowledge_graph.preview');
            $router->resource('knowledge_graph', Admin\Seo\KnowledgeGraphController::class);
        });
    }
);