<?php
/**
 * CustomFieldValue Eloquent Model
 *
 * PHP Version 7
 *
 * @category Mtc\Core\CustomFields
 * @package  Mtc\Core
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Core\CustomFields;

use Illuminate\Database\Eloquent\Model;
use Mtc\Core\Node;

/**
 * CustomFieldValue Eloquent Model
 *
 * Used to store custom field data.
 *
 * @category Mtc\Core\CustomFields
 * @package  Mtc\Core
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class CustomFieldValue extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        // Link to Node that has these fields
        'node_id',
        // CustomGroup parent
        'group_id',
        // CustomField parent
        'field_id',
        // Field Name - for search-ability
        'field_name',
        // It's type (text, textarea, wysiwyg, dropdown, etc)
        'value'
    ];

    /**
     * The field's parent group.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    protected function group()
    {
        return $this->belongsTo(CustomGroup::class, 'group_id');
    }

    /**
     * Relationship to Field that describes the type of this field
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function field()
    {
        return $this->belongsTo(CustomField::class, 'field_id');
    }

    /**
     * Relationship to the Node - object who has this field
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    protected function node()
    {
        return $this->belongsTo(Node::class, 'node_id');
    }

    public function scopeOfGroup($query, $group_id)
    {
        return $query->where('group_id', $group_id);
    }

    public function scopeOfNode($query, $node_id)
    {
        return $query->where('node_id', $node_id);
    }

}
