<?php

namespace Mtc\Core\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Mtc\Core\Http\Controllers\HomeController;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        if (Auth::guard($guard)->check()) {
            $request->session()->flash('message', trans('core::text.no_access'));
            return redirect(action('\\' . HomeController::class . '@index'));
        }

        return $next($request);
    }
}
