<?php
/**
 * Address Model
 *
 * PHP Version 7
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   James Neill <james.neill@mtcmedia.co.uk>
 */

namespace Mtc\Core\Traits;

/**
 * Parent class for storing information about an address.
 *
 * PHP Version 7
 *
 * @category Mtc\Core
 * @package  Mtc\Core
 * @author   James Neill <james.neill@mtcmedia.co.uk>
 */
trait AddressValidator
{
    /**
     * Validation rules for an address
     *
     * @author Craig McCreath <craig.mccreath@mtcmedia.co.uk>
     * @author James Neill <james.neill@mtcmedia.co.uk>
     * @param string $country Country code
     * @param string $type Address type
     * @param string $prefix
     * @return array
     */
    public static function getAddressValidationRules($country, $type = 'billing', $prefix = 'addresses'): array
    {
        return [
            "$prefix.$type.first_name" => 'required',
            "$prefix.$type.last_name" => 'required',
            "$prefix.$type.address1" => 'required',
            "$prefix.$type.city" => 'required',
            "$prefix.$type.postcode" => 'postcode:' . $country,
            "$prefix.$type.country" => 'required',
        ];
    }

    /**
     * Validation rules field names for an address
     *
     * @author Craig McCreath <craig.mccreath@mtcmedia.co.uk>
     * @param string $type Address type
     * @param string $prefix
     * @return array
     */
    public static function getAddressValidationFieldNames($type = 'billing', $prefix = 'addresses'): array
    {
        return [
            "$prefix.$type.first_name" => trans('shop::fields.address.first_name'),
            "$prefix.$type.last_name" => trans('shop::fields.address.last_name'),
            "$prefix.$type.address1" => trans('shop::fields.address.address1'),
            "$prefix.$type.city" => trans('shop::fields.address.city'),
            "$prefix.$type.postcode" => trans('shop::fields.address.postcode'),
            "$prefix.$type.country" => trans('shop::fields.address.country')
        ];
    }
}
